function [] = PopulationResult(Cri_Chan)
%UNTITLED6 此处提供此函数的摘要
%   此处提供详细说明

divTime=-200:1299;
DivCri=20;
LineColor={[0.54  0.824  1.0],[0,0,1],[1 0 0],[1 0.75 0.8]};
%% 挑选出符合条件的位点
 
 for i_sub=1:size(Cri_Chan,2)
SelectChan_temp{1,i_sub}=Cri_Chan(i_sub).HG;
SelectChan_temp{2,i_sub}=Cri_Chan(i_sub).erp;
name2{1,i_sub}=Cri_Chan(i_sub).name;
 end
 datatype={'HG','ERP'};
 labelName={'Relative High-gamma Power (%)','Normalized Amplitude (%)'};
%% 汇总结果，画图
for i_data=1:2
    SelectChan=SelectChan_temp(i_data,:);

    AvgPowerT=[];
    for i_sub=1:length(name2)
        WorkPath=['E:\DATA_SEEG\',name2{i_sub},'_data\电生理结果\LatencyDetect_plot_',...
            datatype{i_data}];
        cd(WorkPath)
        load("FigData.mat")
        ChanAdr=find(ismember(FigData.ChanLabel,SelectChan{i_sub}));
        if i_data==1
        temp=squeeze(FigData.AvgPower(ChanAdr,:,5,:));  % chanXtimeXfreqXcondi HA/NA/NU/LU
        AvgPowerT=cat(1,AvgPowerT,temp);
        elseif i_data==2
        temp=FigData.AvgPower(ChanAdr,:,:);     % chanXtimeXcondi HA/NA/NU/LU
%         temp=squeeze(FigData.AvgPower(ChanAdr,:,:)); 
        baseline=mean(temp(:,divTime<0,:),3);
        baseline_mean=mean( baseline,2);
        std_base=std(baseline,0,2);  %4种条件相同baseline
        ERD=abs((temp-baseline_mean)./std_base);

        AvgPowerT=cat(1,AvgPowerT,ERD);
  
        end



    end


    SEM=squeeze(std(AvgPowerT,0,1)./sqrt(size(AvgPowerT,1)-1))';
    Avg=squeeze(mean(AvgPowerT,1))';

    SEM=smoothdata(SEM,2,"movmean",50);
    Avg=smoothdata(Avg,2,"movmean",50);
axlim=[1.1*(-abs(min(Avg,[],'all'))),1.1*max(Avg,[],'all')];
axRange=0.015*(axlim(2)-axlim(1));

figure;
    LowEdge=Avg-SEM;
    UpEdge=Avg+SEM;
    for j=1:size(AvgPowerT,3)  % channelxtimexcondition
        hold on;
        LE=LowEdge(j,:);
        HE=UpEdge(j,:);
        xconf = [divTime divTime(end:-1:1)] ;%构造正反向的x值，作为置信区间的横坐标值
        yconf = [LE HE(end:-1:1)];%构造y方向的上下范围，作为置信区间的纵坐标值
        p = fill(xconf,yconf,LineColor{1,j});%定义填充区间
        p.EdgeColor = LineColor{1,j};%定义区间边界的填充颜色，此处不设置
        p.LineStyle='none';
        alpha(0.35)
    end

    ptemp=[];
    hold on
    for j=1:size(AvgPowerT,3)
        p=plot(divTime,Avg(j,:),'LineWidth',2);
        p.Color=LineColor{1,j};
        ptemp{j}=p;
    end
    %     yline(0,'k--','LineWidth',1.5);
    xlim([-200 800])
    %     lgd=legend([ptemp{4} ptemp{3} ptemp{2} ptemp{1}],{'Aware(high contrast)',...
    %         'Aware(near-threshold)','Unaware(near-threshold)','Unaware(low contrast)'},...
    %         'Location','north','AutoUpdate','off','NumColumns',2,...
    %         'FontSize',20);
    %     legend boxoff

    % legend({'Uaware','Aware'},'Location','northwest','AutoUpdate','off')
    ax=gca;
    ax.FontSize=15;
    ax.LineWidth=1.5;
    box off
    xlabel('Time from Cue Onset (ms)');
    ylabel(labelName{i_data});
    xline(0,'k--','LineWidth',1.5);
    xline(650,'k--','LineWidth',1.5);
%     ylim([-5 80]);
 ylim(axlim)
    %ttest
    [~,p_sub]=ttest(AvgPowerT(:,:,2),AvgPowerT(:,:,3),'Dim',1);
    pmap=p_sub(:,divTime>=0 & divTime<=650,:);
    %*****************************多重比较校正
    StatThreshOptions.pThreshold = 0.01;
    StatThreshOptions.Correction = 'fdr';
    StatThreshOptions.Control    = [1 2];
    [pmask1, corr_p] = bst_stat_thresh(pmap, StatThreshOptions);   % Benjamini朒ochberg 1995
    %**************************************
    DivIndexT1=[];
    RTepoch=[];
    i=1;
    k=1;
    DivIndexT1{1,k}=strfind(pmask1(i,:,k),ones(1,DivCri));
    %         DivIndexT1{1,k}=find(pmask1(i,:,k)~=0);  %感兴趣时间内不等于0；
    DivSegIndex1=find(diff(DivIndexT1{1,k})~=1);    %速度索引点做差分，找出不连续的点，切分为多段
    if isempty(DivIndexT1{1,k})
        Latency(k,i)=NaN;
        RTepochT{k,i}=[];
    else
        DivSegIndex2=[DivIndexT1{1,k}(1,1),DivIndexT1{1,k}(DivSegIndex1+1);...
            [DivIndexT1{1,k}(DivSegIndex1),DivIndexT1{1,k}(end)]+DivCri-1];%由于变量Adtemp2时间从0开始且采样率为1000（1ms对应一个数据点），所以偷懒省去换算，此处行列为每段反应起止时间；
        RTepoch=divTime(DivSegIndex2+200);
        if numel(RTepoch)==2        %bug，只有2个数时matlab自动存为行向量；
            RTepoch=RTepoch';
        end
        RTepochT{k,i}=RTepoch;      %把每个比较条件的RT阶段都存入元胞
        Latency(k,i)=RTepoch(1);
    end

    %         if ~isempty(RTepochT{k,i})
    %
    %             for i_rt1=1:size(RTepochT{k,i},2)
    %                 %             v2=[RTepochT{k,i}(1,i_rt1),-80;RTepochT{k,i}(2,i_rt1),-80;RTepochT{k,i}(2,i_rt1),80;RTepochT{k,i}(1,i_rt1),80];
    %                 %             patch('Faces',f,'Vertices',v2,'EdgeColor',[1 0.75 0.8],'FaceColor','none','LineWidth',1,'LineStyle',':');
    %                 patch([RTepochT{k,i}(1,i_rt1),RTepochT{k,i}(2,i_rt1),RTepochT{k,i}(2,i_rt1),RTepochT{k,i}(1,i_rt1)],[-20 -20 150 150],0.7*[1 1 1],'FaceAlpha',.3,'EdgeColor',[1 1 1]);
    %
    %             end
    %             text(RTepochT{k,i}(1),0,num2str(RTepochT{k,i}(1)));
    %         end
    line(RTepochT{k,i},[axlim(1)+axRange axlim(1)+axRange],'LineWidth',4,'Color','k')
    text(mean(RTepochT{k,i}(:,1)),axlim(1)+2*axRange,'**','HorizontalAlignment','center','FontSize'...
        ,15)
    hold off
    title(['n=',num2str(size(AvgPowerT,1)),' sites'])
    outputPath='E:\DATA_SEEG\汇总结果\';
    saveas(gcf,[outputPath,'PopulationResult_',datatype{i_data},'_smooth50ms'],'fig')
    saveas(gcf,[outputPath,'PopulationResult_',datatype{i_data},'_smooth50ms'],'tif')
% outputPath='E:\DATA_SEEG\VAandDecision\';
%     saveas(gcf,[outputPath,'Early_PopulationResult_',datatype{i_data},'_smooth50ms'],'fig')
%     saveas(gcf,[outputPath,'Early_PopulationResult_',datatype{i_data},'_smooth50ms'],'tif')


end
end